# A script to verify and filter images based on their size, removing those that don't match the target dimensions along with their corresponding label files.

import os
from PIL import Image

# Folder paths
image_folder = r'D:/***'   # Replace with your image folder path
txt_folder = r'D:/***'  # Replace with your txt folder path
# Target size to check
target_size = (512, 512)

# Get all image filenames in the image folder
image_files = [f for f in os.listdir(image_folder) if os.path.isfile(os.path.join(image_folder, f))]

for image_file in image_files:
    image_path = os.path.join(image_folder, image_file)
    txt_path = os.path.join(txt_folder, os.path.splitext(image_file)[0] + '.xml')
    try:

        # Use 'with' to ensure the file is properly closed after operation
        with Image.open(image_path) as img:
            if img.size != target_size:
                img.close()  # Close image file

                # Delete image file
                os.remove(image_path)
                print(f"Deleted image: {image_file}")

                # Delete corresponding txt file
                if os.path.exists(txt_path):
                    os.remove(txt_path)
                    print(f"Deleted corresponding txt: {os.path.basename(txt_path)}")
                else:
                    print(f"Corresponding txt not found: {os.path.basename(txt_path)}")

    except Exception as e:
        print(f"Error processing {image_file}: {e}")
